import sys
sys.setrecursionlimit(300)

n = int(input())
nums = list(map(str, input().split()))

class Node:
    __slots__ = ("child", "nums")
    def __init__(self):
        self.child = {}
        self.nums = []

root = Node()

for s in nums:
    node = root
    for ch in s:
        if ch not in node.child:
            node.child[ch] = Node()
        node = node.child[ch]
    node.nums.append(s)

groups = []


def dfs(node, chain):
    if node.nums:
        chain.extend(node.nums)
    if not node.child:
        groups.append(chain[:])
        return
    first = True
    for nxt in node.child.values():
        if first:
            dfs(nxt, chain[:])  
            first = False
        else:
            dfs(nxt, [])        
dfs(root, [])

print(len(groups))
for g in groups:
    print(len(g))
    print(" ".join(g))